/* $Id: hiapi.h,v 1.5 2002/02/18 10:56:50 horatiu Exp $
**
** $Revision: 1.5 $
** $Author: horatiu $
** $Date: 2002/02/18 10:56:50 $
**
** $Log: hiapi.h,v $
** Revision 1.5  2002/02/18 10:56:50  horatiu
** add akspccard.sys 1.01 to installer
**
** Revision 1.4  2002/02/08 16:00:36  chris
** replaced old version in inc with r1.38 of dll/hinst/hiapi.h
**
**
*/

/*
 *****************************************************************************
 *
 *  HIAPI.H
 *
 *
 *  Description:  Interface header file for the Aladdin Device Driver API.
 *
 *                  (c) 1996-98 Aladdin Knowledge Systems Ltd.
 *
 *****************************************************************************
 */

#ifndef HIAPI_H
#define HIAPI_H

#ifndef WIN32
#ifndef CHAR
typedef unsigned char   CHAR;
#endif
#endif

#if !defined ( _WINDOWS_ ) && !defined ( __WINDOWS_H ) && !defined ( _INC_WINDOWS )
#error Hiapi.h needs to include windows.h before it
#endif

#include "hierr.h"

#ifndef VER_PLATFORM_WIN32s
#define VER_PLATFORM_WIN32s 0
#endif
#ifndef VER_PLATFORM_WIN32_WINDOWS
#define VER_PLATFORM_WIN32_WINDOWS 1
#endif
#ifndef VER_PLATFORM_WIN32_NT
#define VER_PLATFORM_WIN32_NT 2
#endif

/*
 * Computer type IBM or NEC
 */
#define HI_IBM_TYPE 1
#define HI_NEC_TYPE 2
#define HI_MANUAL_TYPE 0
#define HI_UNKNOWN_TYPE ( ( DWORD )( -1 ) )

/*
 * The device driver is or is not installed.
 */
#define HI_DRIVER_INSTALLED 1
#define HI_DRIVER_NOT_INSTALLED 0
#define HL_DRIVER_INSTALLED 2

/*
 * install/remove options.
 */
#define HI_INSTALL_FULL             1
#define HI_INSTALL_UPDATE           2
#define HI_INSTALL_RELOAD           4
#define HI_INSTALL_WRITE_NEW        8
#define HI_DISABLED_RELOAD          0x80000000
#define HI_KILL_PROCESS             16
#define HI_INSTALL_HASP				32
#define HI_INSTALL_HARDLOCK         0x10000000
#define HI_UNSIGNED					64

#define HI_REMOVE_FULL        0
#define HI_REMOVE_HASP				1
#define HI_REMOVE_HARDLOCK		2 
#define HI_UPDATE_HLHS        4   /* specify that is an update not a entire remove - PnP feature*/

#define W32 1
#define W16 2


#define HI_CHECK_MOUSE               1
#define HI_USE_STI_CLI               2
#define HI_USE_COMPAQ                3
#define HI_USE_USB                   4
#define HI_COMPUTER_TYPE             6
#define HI_PORT_MODE                 7
#define HI_AUTO_DETECT               8
#define HI_COM_ADDRESS               9
#define HI_COM1_ADDRESS             10
#define HI_COM2_ADDRESS             11
#define HI_COM3_ADDRESS             12
#define HI_COM4_ADDRESS             13
#define HI_LPT_ADDRESS              14
#define HI_LPT1_ADDRESS             15
#define HI_LPT2_ADDRESS             16
#define HI_LPT3_ADDRESS             17
#define HI_KEY_SEARCH               48
#define HI_ECP_RETRY				49
#define HI_PORT_ALLOC_RETRY_COUNT	50
#define HI_PORT_ALLOC_FUNCTIONALITY	51
#define HI_PORTDELAY				52

#define HI_DISABLE_DPA              18
#define HI_IO_PORT_ADDRESS          20
#define HI_IO_PORT_ADDRESS0         21
#define HI_IO_PORT_ADDRESS1         22
#define HI_IO_PORT_ADDRESS2         23
#define HI_IO_PORT_ADDRESS3         24
#define HI_IO_PORT_ADDRESS4         25
#define HI_IO_PORT_ADDRESS5         26
#define HI_IO_PORT_ADDRESS6         27
#define HI_IO_PORT_ADDRESS7         28
#define HI_IO_PORT_ADDRESS8         29
#define HI_IO_PORT_ADDRESS9         30
#define HI_IO_PORT_COUNT            31
#define HI_IO_PORT0_COUNT           32
#define HI_IO_PORT1_COUNT           33
#define HI_IO_PORT2_COUNT           34
#define HI_IO_PORT3_COUNT           35
#define HI_IO_PORT4_COUNT           36
#define HI_IO_PORT5_COUNT           37
#define HI_IO_PORT6_COUNT           38
#define HI_IO_PORT7_COUNT           39
#define HI_IO_PORT8_COUNT           40
#define HI_IO_PORT9_COUNT           41
#define HI_NT31_MODE                42
#define HI_HL_VDD                   43
#define HI_CONTROLL_PORT            44
#define HI_FIX_TI                   45
#define HI_MOUSE                    46
#define HI_ENABLE_CONTENTION        47
#define HI_ECP_DMA_INT				53
#define HI_SET_FLAG					54
#define HI_RESET_FLAG				55
#define HI_USE_PCI					56

/*
 *  Information structures definition.
 */
#define HI_ITEM_LEN         128
#define HI_DATE_STR_LEN     20

#define MAX_ERROR_BUFF  1024
#define UNKNOWN_VAL     "Unknown"
#define HI_UNKNOWN_LPT  -1

/*
 * Parameter not supported
 */
#define HI_PARAM_NOT_SUPPORTED      0


#define HI_NORMAL_PORT_MODE         1
#define HI_ECP_PORT_MODE            2
#define HI_BIDI_PORT_MODE           4
#define HI_AUTO_PORT_MODE           8
#define HI_UNKNOWN_PORT_MODE        ((DWORD)(-1))


/*
 *  ComputerType values
 */
#define IBM_KEY_SWITCH              "IBM"
#define NEC_KEY_SWITCH              "NEC"
#define MANUAL_KEY_SWITCH           "Manual"

/*
 *  AutoSearch values
 */
#define AUTOSEARCH_YES              "Y"
#define AUTOSEARCH_NO               "N"

#define HI_UNKNOWN_KEY_SEARCH			((DWORD)(-1))
#define HI_USB_SEARCH					1
#define HI_PARALLEL_SEARCH				2
#define HI_USB_PARALLEL_SEARCH		3
#define HI_WAVE_SEARCH					4

#define HI_FAIL                     ((DWORD)(-1))
#define HI_SUCCESS                  0

#define PARALLEL_PORT               1
#define SERIAL_PORT                 2

typedef struct _HDDINFO
{
    CHAR HIVersion [HI_ITEM_LEN];
    CHAR HIInstallDate [HI_DATE_STR_LEN];
    DWORD HIComputerType;
    CHAR HIProcessorType [HI_ITEM_LEN];
    DWORD DriverStatus;
    DWORD LoaderStatus;
    CHAR HIImagePath [HI_ITEM_LEN];
    DWORD HIPortMode;
    DWORD HILPT1;
    DWORD HILPT2;
    DWORD HILPT3;
    CHAR HIServerPath [HI_ITEM_LEN];
    CHAR HIServerSwitches [HI_ITEM_LEN];
	 DWORD HIKeySearch;
} HDDINFO;
typedef HDDINFO FAR *LPHDDINFO;

typedef struct _HDDSYSINFO
{
    DWORD HISystemType;
} HDDSYSINFO;
typedef HDDSYSINFO FAR *LPHDDSYSINFO;

typedef struct _HDDVersion
{
    DWORD WNT_KDD;        //hardlock.sys
    DWORD WNT_HS_KDD;     //haspnt.sys
    DWORD WNT_HS_VDD;     //haspvdd.dll
    DWORD WNT_HL_VDD;     //hlvdd.dll
    DWORD WNT_USB;        //aksusb.sys
    DWORD WNT_PCCARD;     //akspccard.sys

    DWORD W9X_VXD;        //hardlock.vxd
    DWORD W9X_HL_VDD;     //hlvdd.dll
    DWORD W9X_HS_VXD;     //hasp95.vxd
    DWORD W9X_HS_DL_VXD;  //hasp95dl.vxd
    DWORD W9X_USB;        //aksusb95.sys/aksusb.sys

    DWORD W3X_HL_VXD;     //hardlock.vxd
    DWORD W3X_HL_16DLL;   //api_1lnm.dll
    DWORD W3X_HS_VXD;     //hasp.386
    DWORD W3X_HS_THNKDLL; //hasput16.dll

    DWORD Reserved1;
    DWORD Reserved2;
    DWORD Reserved3;
    DWORD Reserved4;
    DWORD Reserved5;
} HDDVersion;
typedef HDDVersion FAR *LPHDDVersion;


typedef struct _ClientProcess
{
    DWORD ProcessType;
    DWORD PID;
    CHAR	Name[ HI_ITEM_LEN ];
    DWORD Reserved1;
    DWORD Reserved2;
} ClientProcess;
typedef ClientProcess FAR *LPClientProcess;

/*
 * API functions prototypes
 */
#ifdef __cplusplus
extern "C" {
#endif

#define HIENTRY DWORD WINAPI

/*
 * API functions prototypes
 */
HIENTRY HIGetOSType();
HIENTRY HIGetInfo( LPHDDINFO lpHDDInfo, LPHDDSYSINFO lpHDDSysInfo );
HIENTRY HIGetInfoEx( LPHDDINFO lpHDDInfo, DWORD lpHDDInfoSize, LPHDDSYSINFO lpHDDSysInfo, DWORD lpHDDSysInfoSize );
HIENTRY HDDRemove( DWORD RemoveMode );
HIENTRY HDDInstallEx( DWORD InstallMode, 
							 LPSTR DeviceDriverPath, 
							 LPSTR SourcePath, 
							 DWORD HIReserved
						  );
HIENTRY HIGetHDDVersion( LPHDDVersion InstalledVersion, LPHDDVersion InternalVersion );
HIENTRY HDDKillProcess( LPClientProcess pBuffer, LPDWORD Size );
HIENTRY HDDClientProcess( LPClientProcess pBuffer, LPDWORD Size );
HIENTRY HDDGetClientProcessSize();
HIENTRY HISetParameter( DWORD ValueName, LPSTR ValueData );
HIENTRY HILastErrorEx( LPSTR ErrorStr, 
                       DWORD Size, 
                       LPDWORD pSystemError, 
                       LPDWORD pSubError, 
                       DWORD Reserved
							);
HIENTRY HILastError16( LPSTR lpHIErrorStr, 
                       LPDWORD lpSystemError, 
                       LPDWORD lpHISubErr
							);

/*
 * Backward competability API functions prototypes
 */
HIENTRY HDDInstall( DWORD InstallMode );
HIENTRY HISetAutoDetect( BOOL AutoDetect );
HIENTRY HISetPortAddress( DWORD PortType, 
                          DWORD PortNumber, 
                          DWORD PortAddress );
HIENTRY HISetComputerType( DWORD ComputerType );
HIENTRY HISetPortMode( DWORD PortMode );
HIENTRY HIInstallLoader( LPSTR HIReserved1, DWORD SubOperation );
HIENTRY HIRemoveLoader( DWORD HIReserved );
HIENTRY HISetLicenseManagerParameters( LPSTR ServerPath, 
                                       LPSTR ServerSwitch, 
                                       DWORD HIReserved 
												 );
#ifdef WIN32
HIENTRY HILastError( LPSTR *lpHIErrorStr, 
                     LPDWORD lpSystemError, 
                     LPDWORD lpHISubErr 
						 );
#else
HIENTRY HILastError( LPSTR lpHIErrorStr, 
                     LPDWORD lpSystemError, 
                     LPDWORD SubError 
						 );
#endif

#ifdef __cplusplus
}
#endif

#endif // HIAPI_H
